#!/usr/bin/perl
#
# This script deletes excess of pictures in case you want to reduce the number
# of them, without processing all the videos again
#
#    Copyright (C) Pedro Larroy Tovar piotr%NOSPAMlarroy.com

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#


use strict;
use warnings;
use File::Find;

my $KEEP_THIS_MANY=50;
my $PICEXT='png';

sub found {
	if ( -f $_ && m/(.+?)(\d+)\.\Q$PICEXT\E$/ ) {
		print "$_ $1 $2\n";	
		if ($2 > $KEEP_THIS_MANY) {
			print "unlink $_\n";
			unlink($_) or die "unlink: $!";
		}
	}
	if ( -f $_ && m/^\d{8}.\Qpng\E$/ ) {
		print "unlink $_\n";
		unlink($_) or die "unlink: $!";
	}
}
foreach my $arg (@ARGV) {
	if ( ! -d $arg ) {
		die "$arg: not a directory, see usage";
	}
}
find(\&found,@ARGV);


